load([outputPath '\energyUse_hps__manuscriptParams_1-1.mat']);
hps = bv;
load([outputPath '\energyUse_led__manuscriptParams_1-1.mat']);
led = bv;

figure;
hold on
title('Measured and simulated heating input')
plot(300e-6*cumsum(hps.d.uPipe+hps.d.uGroPipe),'--','Color',[0, 0.4470, 0.7410]);
plot(300e-6*cumsum(hps.a.hBoilPipe+hps.a.hBoilGroPipe),'-','Color',[0, 0.4470, 0.7410]);

plot(300e-6*cumsum(led.d.uPipe+led.d.uGroPipe),'--','Color',[0.8500, 0.3250, 0.0980]);
plot(300e-6*cumsum(led.a.hBoilPipe+led.a.hBoilGroPipe),'-','Color',[0.8500, 0.3250, 0.0980]);
xticks(1e6*[0 2 4 6 8 10]);
xlabel('Date')
ylabel('Cumulative heating input (MJ m^{-2})');
grid
legend('HPS measured','HPS simulated','LED measured','LED simulated', 'Location','northwest');
xtickNumToDate(bv,'dd/mm')



